jQuery(document).ready(function($) {

    //Handle changes of the news ticker filter
    $('#daext-filter-form select').on('change', function() {
      $('#daext-filter-form').submit();
    });

    //do not set the default values if we are editing an existing sliding news
    if ( $( "#update-id" ).length ){return;}

    daln_update_default_colors();

    $('#ticker-id').change(function(){

        daln_update_default_colors();

    });

    /*
     * Update the default 'Text Color', 'Text Color Hover' and 'Background Color' based on the values available on the
     * related ticker
     */
    function daln_update_default_colors(){

        var ticker_id = parseInt($('#ticker-id').val(), 10);

        //prepare input for the ajax request
        var data = {
            "action": "update_default_colors",
            "security": daln_nonce,
            "ticker_id": ticker_id
        };

        //ajax
        $.post(daln_ajax_url, data, function(result_json) {

            var data_obj = $.parseJSON(result_json);

            $('#text-color').iris('color', data_obj.sliding_news_color);
            $('#text-color-hover').iris('color', data_obj.sliding_news_color_hover);
            $('#background-color').iris('color', data_obj.sliding_news_background_color);

        });

    }

});